package ru.yandex.calendar.logic.user;

import ru.yandex.bolts.function.Function;

public class NameI18nWithOptionality {
    private final NameI18n nameI18n;
    private final boolean isOptional;

    public NameI18nWithOptionality(NameI18n nameI18n, boolean isOptional) {
        this.nameI18n = nameI18n;
        this.isOptional = isOptional;
    }

    public static Function<NameI18nWithOptionality, NameWithOptionality> getNameWithOptionalityF(final Language language) {
        return a -> new NameWithOptionality(a.nameI18n.getName(language), a.isOptional);
    }

    public NameI18n getNameI18n() {
        return nameI18n;
    }
}
