package ru.yandex.calendar.logic.user;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.UiSettings;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.q.SqlQueryUtils;

/**
 * @author gutman
 */
public class UiSettingsDao extends CalendarJdbcDaoSupport {
    @Autowired
    GenericBeanDao genericBeanDao;

    @RunWithRandomTest
    public Option<UiSettings> findUiSettingsByUid(PassportUid uid) {
        String q = "SELECT * FROM ui_settings WHERE uid = ?";
        return getJdbcTemplate().queryForOption(q, UiSettings.class, uid);
    }

    @RunWithRandomTest(possible=IncorrectResultSizeDataAccessException.class)
    public void updateTodoWebSettingsByUid(String todoWebSettings, PassportUid uid) {
        String q = "UPDATE ui_settings SET todo_web_settings = ? WHERE uid = ?";
        getJdbcTemplate().updateRow(q, todoWebSettings, uid);
    }

    @RunWithRandomTest
    public void deleteUiSettingssByUids(ListF<PassportUid> uids) {
        String q = "DELETE FROM ui_settings WHERE uid " + SqlQueryUtils.inSet(uids);

        if (skipQuery(uids, q)) return;

        getJdbcTemplate().update(q);
    }

    public void saveUiSettings(UiSettings uiSettings) {
        genericBeanDao.insertBean(uiSettings);
    }

}
