package ru.yandex.calendar.logic.user;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.resource.UidOrResourceId;
import ru.yandex.calendar.logic.sharing.participant.ParticipantId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class UserOrMaillist {
    public final PassportUid uid;
    public final Email email;
    public final Kind kind;

    public UserOrMaillist(PassportUid uid, Email email, Kind kind) {
        this.uid = uid;
        this.email = email;
        this.kind = kind;
    }

    public static UserOrMaillist user(PassportUid uid, Email email) {
        return new UserOrMaillist(uid, email, Kind.USER);
    }

    public static UserOrMaillist maillist(PassportUid uid, Email email) {
        return new UserOrMaillist(uid, email, Kind.MAILLIST);
    }

    public PassportUid getUid() {
        return uid;
    }

    public Email getEmail() {
        return email;
    }

    public Option<PassportUid> getUidIfUser() {
        return Option.when(kind == Kind.USER, uid);
    }

    public Option<Email> getEmailIfMaillist() {
        return Option.when(kind == Kind.MAILLIST, email);
    }

    public boolean isUser() {
        return kind == Kind.USER;
    }

    public boolean isMaillist() {
        return kind == Kind.MAILLIST;
    }

    public UidOrResourceId getSubjectId() {
        return UidOrResourceId.user(uid);
    }

    public ListF<ParticipantId> getPossibleIds() {
        return Cf.list(ParticipantId.yandexUid(uid), ParticipantId.invitationIdForExternalUser(email));
    }

    public enum Kind {
        USER,
        MAILLIST,
    }
}
