package ru.yandex.calendar.monitoring;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.LocalDateTime;

import ru.yandex.calendar.util.dates.DateOrDateTime;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.time.MoscowTime;

@AllArgsConstructor
@Getter
@BenderBindAllFields
public class DynamicMonitoringResult {
    private final String message;
    private final DateOrDateTime validTill;
    private final String extendedData;
    @BenderDefaultValue(value="0")
    private final int critCount;

    public DynamicMonitoringResult(String message, Duration expiresIn, String extendedData, int critCount) {
        this(message, DateOrDateTime.dateTime(LocalDateTime.now(MoscowTime.TZ).plus(expiresIn)), extendedData, critCount);
    }
}
