package ru.yandex.calendar.monitoring;

import io.micrometer.core.instrument.MeterRegistry;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;

public class WebApiMonitoring {
    private final static String WEB_REQUESTS_COUNTER_PREFIX = "application.request.web";
    private final static String SUCCESS_EXECUTION = "success";
    private final static String ERROR_EXECUTION = "error";

    @Autowired
    private EwsMonitoring ewsMonitoring;
    @Autowired
    private MeterRegistry registry;

    public void reportSuccessExecution(String uri) {
        registry.counter(StreamEx.of(WEB_REQUESTS_COUNTER_PREFIX, uri, SUCCESS_EXECUTION).joining(".")).increment();
    }

    public void reportErrorExecution(String uri, Throwable t) {
        registry.counter(StreamEx.of(WEB_REQUESTS_COUNTER_PREFIX, uri, ERROR_EXECUTION).joining(".")).increment();
        ewsMonitoring.reportIfEwsException(t);
    }
}
