package ru.yandex.calendar.monitoring;

import lombok.val;
import org.joda.time.Instant;

import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;

public class YtSubscriptionDao extends CalendarJdbcDaoSupport {
    @RunWithRandomTest
    public int countPullExpired(Instant expiredTsBound) {
        return countExpired(expiredTsBound, "last_pull_ts");
    }

    @RunWithRandomTest
    public int countPushExpired(Instant expiredTsBound) {
        return countExpired(expiredTsBound, "last_ping_ts");
    }

    private int countExpired(Instant expiredTsBound, String field) {
        val q = "SELECT count(*) FROM yt_ews_subscription  WHERE " + field + "  < ?";
        return getJdbcTemplate().queryForInt(q, expiredTsBound);
    }
}
