package ru.yandex.calendar.tvm;

import lombok.Value;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

@Value
public class AddRequestTvmHeaderInterceptor implements HttpRequestInterceptor {
    int clientId;
    TvmClient tvmClient;

    @Override
    public void process(HttpRequest request, HttpContext context) {
        if (request.getFirstHeader(TvmHeaders.SERVICE_TICKET) == null) {
            request.setHeader(TvmHeaders.SERVICE_TICKET, tvmClient.getServiceTicketFor(clientId));
        }
    }
}
