package ru.yandex.calendar.tvm;

import lombok.val;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.passport.tvmauth.TvmToolSettings;

@Configuration
public class TvmClientConfiguration {
    @Bean(destroyMethod = "close")
    public ru.yandex.passport.tvmauth.NativeTvmClient getLibraryClient(@Value("${tvm.self.alias}") String selfAlias) {
        val settings = new TvmToolSettings(selfAlias);

        return ru.yandex.passport.tvmauth.NativeTvmClient.create(settings);
    }

    @Bean
    public TvmClient getClient(ru.yandex.passport.tvmauth.NativeTvmClient libraryClient) {
        return new TvmClientImpl(libraryClient);
    }

    @Bean
    public TvmFirewall tvmFirewall(EnvironmentType environmentType) {
        return environmentType == EnvironmentType.STRESS
                ? new TvmFirewall.AllowAny()
                : new TvmFirewallImpl();
    }

    @Bean
    public TvmManager tvmManager() {
        return new TvmManager();
    }
}
