package ru.yandex.calendar.tvm;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.val;

import ru.yandex.passport.tvmauth.TicketStatus;

@AllArgsConstructor
public class TvmClientImpl implements TvmClient {
    private final ru.yandex.passport.tvmauth.NativeTvmClient client;

    @Override
    public String getServiceTicketFor(int clientId) {
        return client.getServiceTicketFor(clientId);
    }

    @Override
    public TvmServiceResponse checkServiceTicket(String ticketBody) {
        val ticket = client.checkServiceTicket(ticketBody);
        val status = ticket.getStatus();
        return new TvmServiceResponse(status, status == TicketStatus.OK ? Optional.of(ticket.getSrc()) : Optional.empty());
    }

    @Override
    public TvmUserResponse checkUserTicket(String ticketBody) {
        val ticket = client.checkUserTicket(ticketBody);
        val status = ticket.getStatus();
        return new TvmUserResponse(status, status==TicketStatus.OK ? ticket.getUids() : new long[0]);
    }
}
