package ru.yandex.calendar.tvm;

import ru.yandex.calendar.logic.event.ActionSource;

public interface TvmFirewall {
    boolean isSourceAllowed(long src, ActionSource actionSource);
    boolean isActionAllowedWithoutServiceTicket(ActionSource actionSource);
    boolean isActionAllowedWithoutUserTicket(int src);

    class AllowAny implements TvmFirewall {

        @Override
        public boolean isSourceAllowed(long src, ActionSource actionSource) {
            return true;
        }

        @Override
        public boolean isActionAllowedWithoutServiceTicket(ActionSource actionSource) {
            return true;
        }

        @Override
        public boolean isActionAllowedWithoutUserTicket(int src) {
            return true;
        }
    }
}
