package ru.yandex.calendar.tvm.exceptions;

import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.passport.tvmauth.TicketStatus;

public class InvalidTvmTicketException extends TvmUnauthenticatedException {
    public InvalidTvmTicketException(String headerName, String source, TicketStatus status, ActionSource actionSource) {
        super("Unable to parse " + headerName + ". Source=" + source + ", status=" + status + ", actionSource=" + actionSource);
    }

    public InvalidTvmTicketException(String headerName, String ip, String message) {
        super("Unable to parse " + headerName + ". From ip =" + ip + ", status=" + message);
    }
}
