package ru.yandex.calendar.unistat;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.util.JettyConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurationBuilder;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.SimpleResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.version.Version;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

@Configuration
@Import({
        UnistatConfiguration.class,
})
public class ApiUnistatContextConfiguration {
    @Bean
    public ApplicationInfo applicationInfo(CalendarAppName appName, Version version) {
        return new ApplicationInfo(appName.appName(), version.getProjectVersion());
    }

    @Bean
    @Qualifier("unistatJetty")
    public SingleWarJetty unistatJetty() {
        return JettyConfiguration.fromProperties("unistat").consJetty();
    }

    @Bean
    @Qualifier("unistatActionApp")
    public ActionApp unistatActionApp(ApplicationInfo info) {
        ActionConfigurationBuilder builder = ActionConfigurationBuilder.cons(info);

        builder.register(new SimpleResultSerializer());
        builder.setResultType(MediaType.TEXT_PLAIN);
        return ActionConfigurator.configure(Cf.list(unistatActions()), builder);
    }

    @Bean
    public ActionInvocationServlet unistatActionInvocationServlet(
            @Qualifier("unistatJetty") SingleWarJetty jetty,
            @Qualifier("unistatActionApp") ActionApp actionApp) {
        ActionInvocationServlet servlet = actionApp.createServlet();
        jetty.addServletMapping("/unistat", servlet);
        return servlet;
    }

    @Bean
    public UnistatActions unistatActions() {
        return new UnistatActions();
    }
}
