package ru.yandex.calendar.unistat;

import java.io.IOException;
import java.io.StringWriter;

import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.kinopoisk.micrometer.yasm.YasmMeterRegistry;
import ru.yandex.kinopoisk.micrometer.yasm.YasmUnistatJsonWriter;
import ru.yandex.misc.thread.WithTlTimeoutInMillis;

@ActionContainer
public class UnistatActions {
    @Autowired
    private YasmMeterRegistry registry;

    @Action
    @Path(methods = HttpMethod.GET, value = "/")
    @WithTlTimeoutInMillis(3000)
    public String yasmMetrics() throws IOException {
        val writer = new StringWriter();
        YasmUnistatJsonWriter.writeTo(registry, writer);
        return writer.toString();
    }
}
