package ru.yandex.calendar.util;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.reqid.RequestIdStack;

/**
 * @author dbrylev
 */
public class ExtendedPushRequestIdHandler extends HandlerWrapper {

    static final String RID_ATTR = "ru.yandex.RequestId";

    @Override
    public void handle(String target, Request baseRequest,
            HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
    {
        RequestIdStack.Handle h = getRid(request).map(RequestIdStack::pushReplace).getOrElse(RequestIdStack::push);
        baseRequest.setAttribute(RID_ATTR, h.getValue());
        try {
            super.handle(target, baseRequest, request, response);
        } finally {
            h.popSafely();
        }
    }

    private Option<String> getRid(HttpServletRequest request) {
        return Option.ofNullable(request.getHeader("x-request-id")).map(s -> StringUtils.substring(s, 0, 15));
    }
}
