package ru.yandex.calendar.util;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.bazinga.impl.FullJobId;
import ru.yandex.commune.bazinga.impl.JobId;
import ru.yandex.commune.bazinga.impl.JobInfoValue;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.impl.OnetimeUtils;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;

/**
 * @author dbrylev
 */
public class PgOnetimeUtils {

    public static OnetimeJob makeJob(OnetimeTask task, Instant scheduleTime) {
        return new OnetimeJob(
                new FullJobId(task.id(), new JobId(UUID.randomUUID())),
                Option.of(Instant.now()), scheduleTime,
                Option.of(OnetimeUtils.getActiveUniqueIdentifier(task)),
                new String(BazingaBender.mapper.serializeJson(task.getParameters())), JobInfoValue.ready(),
                Option.empty(), Cf.set(), Option.empty(), task.priority(), Option.empty());
    }

}
