package ru.yandex.calendar.util;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.property.PropertiesHolder;

/**
 * @author dbrylev
 */
public class PropertiesHolderUtils {

    public static int getOrThrowInt(String name) {
        return getInt(name).getOrThrow(undefined(name));
    }

    public static Option<Integer> getInt(String name) {
        return get(name).map(value -> parseInt(name, value));
    }

    public static boolean getOrThrowBool(String name) {
        return getBool(name).getOrThrow(undefined(name));
    }

    public static Option<Boolean> getBool(String name) {
        return get(name).map(value -> parseBool(name, value));
    }

    public static String getOrThrow(String name) {
        return get(name).getOrElse(undefined(name));
    }

    public static Option<String> get(String name) {
        ListF<String> tokens = Cf.x(name.split("\\."));

        Tuple2<String, Option<String>> kv = Tuple2.tuple(tokens.last(), getNoCut(tokens.last()));

        kv = tokens.rdrop(1).foldRight(kv, (token, acc) -> Tuple2.tuple(
                token + "." + acc.get1(), getNoCut(token + "." + acc.get1()).orElse(acc.get2())));

        return kv.get2();
    }

    private static Option<String> getNoCut(String name) {
        return Option.ofNullable(PropertiesHolder.properties().get(name)).cast();
    }

    private static String undefined(String name) {
        return "Property " + name + " is not defined";
    }

    private static int parseInt(String name, String value) {
        return Cf.Integer.parseSafe(value)
                .getOrThrow("Failed to parse property " + name + " value " + value + " as int");
    }

    private static boolean parseBool(String name, String value) {
        return Cf.Boolean.parse(value);
    }
}
