package ru.yandex.calendar.util;

import java.util.ConcurrentModificationException;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.misc.cache.tl.TlCache;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;

/**
 * @author dbrylev
 */
public class TlCacheUtils {

    private static final FieldX cacheDataField = ClassX.wrap(TlCache.class)
            .getDeclaredField("cacheData").setAccessibleTrueReturnThis();

    private static final FieldX handleDataField = ClassX.wrap(TlCache.Handle.class)
            .getDeclaredField("data").setAccessibleTrueReturnThis();

    @SuppressWarnings("unchecked")
    private static final Function0<ThreadLocal<TlCache.Handle>> getCacheData =
            () -> (ThreadLocal<TlCache.Handle>) cacheDataField.get(null);

    @SuppressWarnings("unchecked")
    private static final Function<TlCache.Handle, MapF<Object, Object>> getHandleData =
            h -> (MapF<Object, Object>) handleDataField.get(h);


    public static <T, R> Function<T, R> inheritF(Function<T, R> func) {
        Option<TlCache.Handle> parent = Option.ofNullable(getCacheData.apply().get());

        if (!parent.isPresent()) {
            return func;
        }

        return t -> {
            TlCache.Handle handle = TlCache.push();
            try {
                try {
                    parent.forEach(p -> getHandleData.apply(handle).putAll(getHandleData.apply(p)));
                } catch (ConcurrentModificationException ignored) {}

                return func.apply(t);

            } finally {
                handle.popSafely();
            }
        };
    }

    public static <R> Function0<R> inheritF(Function0<R> func) {
        Function<?, R> function = inheritF(func.asFunction());

        return () -> function.apply(null);
    }

    public static <T, R> Function<T, R> withCacheF(Function<T, R> func) {
        return t -> {
            TlCache.Handle handle = TlCache.push();
            try {
                return func.apply(t);

            } finally {
                handle.popSafely();
            }
        };
    }

    public static <R> Function0<R> withCacheF(Function0<R> func) {
        Function<?, R> function = withCacheF(func.asFunction());

        return () -> function.apply(null);
    }

    public static Function0V withCacheF(Function0V func) {
        return withCacheF(func.asFunction0ReturnNull()).asFunction0V();
    }
}
