package ru.yandex.calendar.util.base;

import java.util.regex.Pattern;

import ru.yandex.calendar.util.resources.UStringLiteral;
import ru.yandex.misc.lang.StringUtils;

/**
 * Common convenient routines with base classes
 *
 * @author ssytnik
 */
public class AuxBase {
    private static final Pattern QUOTE_PATTERN = Pattern.compile(UStringLiteral.QUOTE_PATTERN_STR);

    // Can return null or throw exception on error
    public static Integer toNullableIntUnsafe(String str) {
        if (StringUtils.isEmpty(str)) { return null; }
        return Integer.parseInt(str);
    }

    // Can return null or throw exception on error
    public static Long toNullableLongUnsafe(String str) {
        if (StringUtils.isEmpty(str)) { return null; }
        return Long.parseLong(str);
    }

    /**
     * Replaces quotes of different types (except &quot;) with single quotes
     * @param s string to be converted to a single-quoted one (can be null)
     * @return converted string
     */
    public static String toSingleQuotedStringExceptQuot(String s) {
        return (s == null ? null : QUOTE_PATTERN.matcher(s).replaceAll("'"));
    }

}
