package ru.yandex.calendar.util.base;

import ru.yandex.misc.lang.StringUtils;

/**
 * Another convenient representation of boolean.
 * Normal form: can be 1 (true) or 0 (false).
 * When parsed from String, treats null, empty string ot &quot;0&quot; as 0,
 * and everything else as 1.
 *
 * @author ssytnik
 */
public class Binary {
    public static final String TRUE_STR = "1";
    public static final String FALSE_STR = "0";
    public static final Long TRUE_LNG = 1L;
    public static final Long FALSE_LNG = 0L;

    // Factories and other static stuff

    public static boolean parseBoolean(String s) {
        return (StringUtils.isNotEmpty(s) && !s.equals("0"));
    }

    public static Long parseLong(String s) {
        return (parseBoolean(s) ? TRUE_LNG : FALSE_LNG);
    }

    public static String parseString(String s) {
        return (parseBoolean(s) ? TRUE_STR : FALSE_STR); //return valueOf(s).toString();
    }

    public static boolean toBoolean(Long l) {
        return (l != null && !l.equals(FALSE_LNG));
    }

    public static boolean toBoolean(Boolean b) {
        return (b != null && b);
    }

    public static Long toLong(Boolean b) {
        return (b != null && b ? TRUE_LNG : FALSE_LNG);
    }

    public static String toString(Boolean b) {
        return (b != null && b ? TRUE_STR : FALSE_STR);
    }

    public static String toString(Long l) {
        return (l != null && l != 0 ? TRUE_STR : FALSE_STR);
    }

}
