package ru.yandex.calendar.util.base;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.function.Supplier;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.bolts.function.Function2;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author gutman
 */
public class Cf2 {

    public static <A> ListF<A> merge(ListF<A> input, final Function2<A, A, ListF<A>> merger) {
        ListF<A> result = Cf.arrayListWithCapacity(input.size());
        result.addAll(input.firstO());

        for (int i = 1; i < input.size(); ++i) {
            A last = result.remove(result.size() - 1);
            result.addAll(merger.apply(last, input.get(i)));
        }
        return result;
    }

    public static <E, K> MapF<K, ListF<E>> stableGroupBy(CollectionF<E> c, Function<? super E, ? extends K> m) {
        if (c.isEmpty()) return Cf.map();

        MapF<K, ListF<E>> map = Cf.x(new LinkedHashMap<K, ListF<E>>());
        for (E e : c) {
            K key = m.apply(e);
            ListF<E> list = map.getOrElseUpdate(key, Cf::arrayList);
            list.add(e);
        }
        return map;
    }

    public static <E, K> MapF<K, E> stableMapToKey(CollectionF<E> c, Function<? super E, ? extends K> mapper) {
        if (c.isEmpty()) return Cf.map();

        MapF<K, E> map = Cf.x(new LinkedHashMap<K, E>(c.size(), 1F));

        c.forEach(e -> map.put(mapper.apply(e), e));

        return map;
    }

    public static <A, B> Tuple2List<A, B> flatBy2(Tuple2List<A, Option<B>> list) {
        Tuple2List<A, B> result = Tuple2List.arrayList();

        for (Tuple2<A, Option<B>> pair : list) {
            if (pair.get2().isPresent()) {
                result.add(Tuple2.tuple(pair.get1(), pair.get2().get()));
            }
        }
        return result.makeReadOnly();
    }

    public static <A> Function1B<Option<A>> isSomeOfF(CollectionF<A> values) {
        SetF<A> valuess = values.unique();

        return o -> o.isPresent() && valuess.containsTs(o.get());
    }

    public static <A> Function1B<Option<A>> isSomeF(A value) {
        return o -> o.isSome(value);
    }

    public static <A, B, R> Function2<A, B, R> asFunction2Ignore1(Function<B, R> function) {
        return (o, b) -> function.apply(b);
    }

    public static <A, B, R> Function2<A, B, R> asFunction2Ignore2(Function<A, R> function) {
        return (a, o) -> function.apply(a);
    }

    public static <A, B> Tuple2List<A, B> join(CollectionF<A> as, CollectionF<B> bs) {
        Tuple2List<A, B> result = Tuple2List.arrayList();
        for (A a : as) {
            for (B b : bs) {
                result.add(a, b);
            }
        }
        return result.makeReadOnly();
    }

    public static <A> ListF<ListF<A>> splitSorted(ListF<A> as, Comparator<A> comparator) {
        as = as.sorted(comparator);

        ListF<ListF<A>> result = Cf.arrayList();
        A prev = null;

        for (A cur: as) {
            if (prev == null || comparator.compare(prev, cur) != 0) {
                result.add(Cf.arrayList());
            }
            result.last().add(cur);
            prev = cur;
        }
        return result;
    }

    public static <A> Function1B<Collection<A>> existsF(Function1B<A> predicate) {
        return as -> Cf.x(as).exists(predicate);
    }

    public static <A, R> Function<A, R> f(Function<A, R> function) {
        return function;
    }

    public static <A> Function0<A> f0(Function0<A> function) {
        return function;
    }

    public static <A> Function1B<A> f1B(Function1B<A> function) {
        return function;
    }

    public static <A, B, R> Function2<A, B, R> f2(Function2<A, B, R> function) {
        return function;
    }

    @SuppressWarnings("unchecked")
    public static <B> Function0<B> consF(ClassX<B> clazz) {
        return ((Supplier<B>) clazz.getConstructor(new Class<?>[0]).toSam(Supplier.class))::get;
    }

    @SuppressWarnings("unchecked")
    public static <A, R> Function<A, R> consF(ClassX<R> clazz, Class<A> aClass) {
        return clazz.getConstructor(new Class<?>[] { aClass }).toSam(Function.class);
    }

    @SuppressWarnings("unchecked")
    public static <A, B, R> Function2<A, B, R> consF(ClassX<R> clazz, Class<A> aClass, Class<B> bClass) {
        return clazz.getConstructor(new Class<?>[] { aClass, bClass }).toSam(Function2.class);
    }

    public static <A> Class<ListF<A>> listClass() {
        return ClassX.wrap(ListF.class).<ListF<A>>uncheckedCast().getClazz();
    }
}
