package ru.yandex.calendar.util.base;

import java.util.UUID;

import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.net.HostnameUtils;

/**
 * Generates unique identifiers for different purposes
 * @author ssytnik
 */
public class UidGen {
    // Returns string of 32 hex digits
    private static String createRndLen32() { return UUID.randomUUID().toString().replaceAll("-", ""); }

    private static String getHostThreadYear() {
        return
            HostnameUtils.localHostnameShort() + "/" +
            Thread.currentThread().getId() + "/" +
            new DateTime(ISOChronology.getInstanceUTC()).getYear()
            ;
    }

    // Expected length: 1 .. 32
    private static String getHostThreadYearHash(int length) {
        byte[] srcBytes = CharsetUtils.encodeUtf8ToArray(getHostThreadYear());
        return UUID.nameUUIDFromBytes(srcBytes).toString().replaceAll("-", "").substring(0, length);
    }

    // Generates human-readable unique identifier of variable length
    // that contains host name, thread id and random UUID
    public static String createOpenToken() {
        return (getHostThreadYear() + "/" + createRndLen32());
    }

    // Generates non-human-readable unique private token of the fixed length
    public static String createPrivateToken() {
        String res = (getHostThreadYearHash(8) + createRndLen32());
        if (res.length() != 40) {
            final String msg = "Length self-check failed for new ptk = " + res;
            throw new CommandRunException(msg);
        }
        return res;
    }

//    public static void main(String[] args) {
//        System.out.println("new GUID: " + createRndLen32());
//    }
}
