package ru.yandex.calendar.util.color;

import ru.yandex.misc.lang.Validate;

/**
 * @author gutman
 */
public class ColorUtils {

    public static String formatColor(int rrggbb) {
        return Color.fromRgb(rrggbb).printRgb();
    }

    /**
     * Accepts coded color within 0x000000-0xFFFFFF range
     * in #... (hex) or ... (decimal) format and returns it
     * @param color coded color in either decimal or hexadecimal (#...) format
     * @return parsed value
     */
    public static int unformatColor(String color) {
        if (color.charAt(0) == '#') {
            return Color.parseRgb(color).getRgb();
        } else {
            // XXX: what for?
            int i = Integer.parseInt(color);
            Validate.isTrue(i >= 0 && i <= 0xFFFFFFL);
            return i;
        }
    }

}
