package ru.yandex.calendar.util.conf;


import javax.annotation.PostConstruct;
import javax.sql.DataSource;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.db.masterSlave.MasterSlaveDataSource;
import ru.yandex.misc.db.masterSlave.MasterSlaveDataSourceBase;
import ru.yandex.misc.db.pool.dbcp.DbcpConfiguration;
import ru.yandex.misc.db.pool.dbcp.DbcpDataSource;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Stepan Koltsov
 */
public class CalendarDataSourceFactoryBean implements FactoryBean<MasterSlaveDataSourceBase> {
    private static final Logger logger = LoggerFactory.getLogger(CalendarDataSourceFactoryBean.class);

    private String writeUrl;
    private String readUrl1;
    private String readUrl2;
    private String commonUrlPart;
    private String user;
    private String password;
    private int maxActiveConnections = 200;

    private MasterSlaveDataSourceBase dataSource;

    @PostConstruct
    public void init() {
        DbcpConfiguration conf = new DbcpConfiguration();
        //conf.setDefaultTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
        // testOnReturn - not used now
        // testWhileIdle - not supported now
        conf.setMaxTotal(maxActiveConnections);
        conf.setMaxIdle(110);
        conf.setMinIdle(4);
        conf.setTimeBetweenEvictionRunsMillis(60000);
        conf.setMaxWaitMillis(4000);
        conf.setPingMaxWaitSecs(2);
        conf.setPsPooling(false);
        conf.setTestOnBorrow(true);
        conf.setTestOnReturn(false);

        DataSource masterDs = new DbcpDataSource(writeUrl + commonUrlPart, user, password, conf);

        ListF<DataSource> slaveDss = Cf.arrayList();

        SetF<String> usedUrls = Cf.hashSet(writeUrl);

        for (String readUrl : Cf.list(readUrl1, readUrl2)) {
            if (readUrl.isEmpty())
                continue;
            if (usedUrls.containsTs(readUrl))
                continue;
            slaveDss.add(new DbcpDataSource(readUrl + commonUrlPart, user, password, conf));
            usedUrls.add(readUrl);
        }

        if (!slaveDss.isEmpty())
            dataSource = new CalendarMasterSlaveDataSource(Cf.list(masterDs), slaveDss);
        else
            dataSource = new CalendarReadWriteSingleDataSource(masterDs);

        logger.info("Initialized datasource: " + dataSource);
    }

    @Override
    public MasterSlaveDataSourceBase getObject() throws Exception {
        return dataSource;
    }

    @Override
    public Class<MasterSlaveDataSource> getObjectType() {
        return MasterSlaveDataSource.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Required
    @Value("${calendar.jdbc.sUrl1}")
    public void setSlaveUrl1(String readUrl1) {
        this.readUrl1 = readUrl1;
    }

    @Required
    @Value("${calendar.jdbc.sUrl2}")
    public void setSlaveUrl2(String readUrl2) {
        this.readUrl2 = readUrl2;
    }

    @Required
    @Value("${calendar.jdbc.mUrl}")
    public void setMasterUrl(String writeUrl) {
        this.writeUrl = writeUrl;
    }

    @Required
    @Value("${calendar.jdbc.login}")
    public void setUser(String user) {
        this.user = user;
    }

    @Required
    @Value("${calendar.jdbc.commonUrlPart}")
    public void setCommonUrlPart(String commonUrlPart) {
        this.commonUrlPart = commonUrlPart;
    }

    @Required
    @Value("${calendar.jdbc.password}")
    public void setPassword(String password) {
        this.password = password;
    }

    @Value("${calendar.jdbc.maxActiveConnections:-200}")
    public void setMaxActiveConnections(int maxActiveConnections) {
        this.maxActiveConnections = maxActiveConnections;
    }

} //~
