package ru.yandex.calendar.util.conf;

import java.sql.Connection;

import javax.sql.DataSource;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.util.db.CalendarJdbcTemplate;
import ru.yandex.calendar.util.db.DbUtils;
import ru.yandex.misc.db.masterSlave.MasterSlaveDataSource;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author Stepan Koltsov
 *
 * @see CalendarReadWriteSingleDataSource
 */
public class CalendarMasterSlaveDataSource extends MasterSlaveDataSource {
    private static final Logger logger = LoggerFactory.getLogger(CalendarMasterSlaveDataSource.class);

    public CalendarMasterSlaveDataSource(ListF<DataSource> masterDss, ListF<DataSource> slaveDss,
            boolean checkReadOnly)
    {
        super(masterDss, slaveDss, checkReadOnly);
    }

    public CalendarMasterSlaveDataSource(ListF<DataSource> masterDss, ListF<DataSource> slaveDss) {
        super(masterDss, slaveDss);
    }

    @Override
    protected boolean isDataSourceOkBesidesPingAndReadOnlyCheck(DataSource ds) {
        if (!super.isDataSourceOkBesidesPingAndReadOnlyCheck(ds))
            return false;

        try {
            CalendarJdbcTemplate jdbcTemplate = new CalendarJdbcTemplate(ds);

            DbUtils.verifyMysqlTzIds(jdbcTemplate, TimeUtils.EUROPE_MOSCOW_TIME_ZONE.getID());

            return true;
        } catch (Exception e) {
            logger.warn(e, e);
            return false;
        }
    }

    @Override
    protected Connection doGetConnectionForPolicy(MasterSlavePolicy policy) {
        if (CalendarMasterSlaveContextHolder.isForceMasterUnavailable() && policy.isWrite()) {
            throw super.databaseUnavailableException(policy, "forced master unavailable");
        } else {
            return super.doGetConnectionForPolicy(policy);
        }
    }

} //~
