package ru.yandex.calendar.util.conf;

import java.sql.Connection;

import javax.sql.DataSource;

import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.ReadWriteSingleDataSource;

/**
 * @author Stepan Koltsov
 *
 * @see CalendarMasterSlaveDataSource
 */
public class CalendarReadWriteSingleDataSource extends ReadWriteSingleDataSource {

    public CalendarReadWriteSingleDataSource(DataSource target) {
        super(target);
    }

    @Override
    protected Connection doGetConnectionForPolicy(MasterSlavePolicy policy) {
        if (CalendarMasterSlaveContextHolder.isForceMasterUnavailable() && policy.isWrite()) {
            throw super.databaseUnavailableException(policy, "forced master unavailable");
        } else {
            return super.doGetConnectionForPolicy(policy);
        }
    }

} //~
