package ru.yandex.calendar.util.conf;

import java.util.TimeZone;

import org.joda.time.DateTimeZone;

import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.thread.ThreadLocalTimeout;
import ru.yandex.misc.time.NoDateTimeZone;

public class Configuration {
    public synchronized static void initializeEnvironment(boolean forTest) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DateTimeZone.setDefault(forTest ? new NoDateTimeZone() : DateTimeZone.UTC);

        // Experimental
        JdbcMetricsSwitch.ENABLED = true;

        // doesn't work
        System.setProperty("org.apache.cxf.Logger", "org.apache.cxf.common.logging.Log4jLogger");
        System.setProperty("org.apache.spring.validation.mode", "VALIDATION_NONE");

        if (EnvironmentType.getActive() == EnvironmentType.DEVELOPMENT) {
            ThreadLocalTimeout.setEnabled(false);
        }
    }
}
