package ru.yandex.calendar.util.data;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;

/**
 * @author ssytnik
 */
public abstract class AbstractDataProvider<T> implements DataProvider {
    @Override
    public String getText(String name, boolean presence) {
        return getTextCheckDefined(getItemCheckPresence(name, presence, true));
    }

    @Override
    public DataProvider getDataProvider(String name, boolean presence) {
        return getDataProviderCheckDefined(getItemCheckPresence(name, presence, false));
    }

    @Override
    public ListF<String> getTexts(String name) {
        return getItems(name).map(new Function<T, String>() {
            @Override public String apply(T a) {
                return getTextCheckDefined(a);
            };
        });
    }

    @Override
    public ListF<DataProvider> getDataProviders(String name) {
        return getItems(name).map(new Function<T, DataProvider>() {
            @Override public DataProvider apply(T a) {
                return getDataProviderCheckDefined(a);
            }
        });
    }

    private @Nullable T getItemCheckPresence(String name, boolean presence0, boolean isText) {
        T res = getItem(name);
        if (presence0 && !isDefined(res, isText)) {
            throw new CommandRunException(
                "Required " +
                "item '" + name + "' " +
                "is not found"
            );
        }
        return res;
    }

    private String getTextCheckDefined(T item) {
        return isDefined(item, true) ? getText(item) : null; // empty -> null
    }

    private DataProvider getDataProviderCheckDefined(T item) {
        return isDefined(item, false) ? getDataProvider(item) : null;
    }

    protected abstract T getItem(String name);

    protected abstract ListF<T> getItems(String name);

    protected abstract boolean isDefined(T item, boolean isText);

    protected abstract String getText(T item);

    protected abstract DataProvider getDataProvider(T item);
}
