package ru.yandex.calendar.util.data;

import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.lang.StringUtils;

/**
 * Prefixed data provider that supports well-known aliases
 * @author ssytnik
 */
public abstract class AliasedDataProvider extends PrefixedDataProvider {
    private static final Map<String, String> aliases;

    static {
        // Aliases use fixed names as parameters (with hyphen changed to underscore)
        aliases = Cf.hashMap();
        aliases.put("event", "e");
        aliases.put("filter", "f");
        aliases.put("general", "g");
        aliases.put("layer", "l"); // TODO: add to Interaction_API.doc
        aliases.put("notification", "n");
        aliases.put("repetition", "r");
        aliases.put("user", "u");
        aliases.put("attachments", "as");
        aliases.put("attachment", "a");
    }

    // Public static: for testing purposes (generate RequestData from xml)
    public static String getAlias(String name) {
        String alias = aliases.get(name);
        return (StringUtils.isNotEmpty(alias) ? alias : name);
    }

    protected AliasedDataProvider(String aliasedPrefix) {
        super(aliasedPrefix);
    }

    @Override
    protected String getFullName(String name) {
        return fullPrefix + getAlias(getFixedName(name));
    }
}
