package ru.yandex.calendar.util.data;

import java.util.Map;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * Provides data from a given map having aliased keys
 * (NOTE: does not perform clone for the given map)
 * @author ssytnik
 */
public class AliasedMapDataProvider extends AliasedDataProvider {
    Map<String, String> m;

    // Creates root request data provider
    public AliasedMapDataProvider(Map<String, String> m) {
        this(m, "");
    }

    protected AliasedMapDataProvider(Map<String, String> m, String aliasedPrefix) {
        super(aliasedPrefix);
        Validate.notNull(m);
        this.m = m;
    }

    @Override
    public String toString() {
        return m.toString(); // TODO: when data providers are rewritten, filter params
    }

    @Override
    protected String getNullableValue(String fullName, boolean forceNull) {
        String res = m.get(fullName);
        return (forceNull ? StringUtils.defaultIfEmpty(res, null) : res);
    }

    @Override
    protected DataProvider getDataProvider(String aliasedPrefix) {
        return new AliasedMapDataProvider(m, aliasedPrefix);
    }
}
