package ru.yandex.calendar.util.data;

import ru.yandex.calendar.util.idlent.RequestWrapper;
import ru.yandex.misc.lang.Validate;

/**
 * Provides data from a given request having aliased keys
 * @author ssytnik
 */
public class AliasedRequestDataProvider extends AliasedDataProvider {
    RequestWrapper rw;

    public AliasedRequestDataProvider(RequestWrapper rw) {
        this(rw, "");
    }

    protected AliasedRequestDataProvider(RequestWrapper rw, String aliasedPrefix) {
        super(aliasedPrefix);
        Validate.notNull(rw);
        this.rw = rw;
    }

    @Override
    public String toString() {
        return rw.toString(); // TODO: when data providers are rewritten, filter params
    }

    @Override
    protected String getNullableValue(String fullName, boolean forceNull) {
        return rw.getNullableString(fullName, forceNull);
    }

    @Override
    protected DataProvider getDataProvider(String aliasedPrefix) {
        return new AliasedRequestDataProvider(rw, aliasedPrefix);
    }
}
