package ru.yandex.calendar.util.data;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.ListF;

/**
 * Provides data from an abstract source like request, map or xml.
 * Accepts names in xml-like format and then converts properly.
 * @author ssytnik
 */
public interface DataProvider {
    @Nullable
    String getText(String name, boolean required);
    @Nullable
    DataProvider getDataProvider(String name, boolean required);

    ListF<String> getTexts(String name);
    ListF<DataProvider> getDataProviders(String name);
}
