package ru.yandex.calendar.util.data;

import java.util.Map;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * Provides data from a given map
 * @author ssytnik
 */
public class MapDataProvider extends PrefixedDataProvider {
    Map<String, String> m;

    public MapDataProvider(Map<String, String> m) {
        this(m, "");
    }

    protected MapDataProvider(Map<String, String> m, String prefix) {
        super(prefix);
        Validate.notNull(m);
        this.m = m;
    }

    @Override
    public String toString() {
        return m.toString(); // TODO: when data providers are rewritten, filter params
    }

    @Override
    protected String getNullableValue(String fullName, boolean forceNull) {
        String res = m.get(fullName);
        return (forceNull ? StringUtils.defaultIfEmpty(res, null) : res);
    }

    @Override
    protected DataProvider getDataProvider(String prefix) {
        return new MapDataProvider(m, prefix);
    }
}
