package ru.yandex.calendar.util.data;

import ru.yandex.calendar.util.idlent.RequestWrapper;
import ru.yandex.misc.lang.Validate;

/**
 * Provides data from a given request
 * @author ssytnik
 */
public class RequestDataProvider extends PrefixedDataProvider {
    RequestWrapper rw;

    public RequestDataProvider(RequestWrapper rw) {
        this(rw, "");
    }

    protected RequestDataProvider(RequestWrapper rw, String prefix) {
        super(prefix);
        Validate.notNull(rw);
        this.rw = rw;
    }

    @Override
    public String toString() {
        return rw.toString(); // TODO: when data providers are rewritten, filter params
    }

    @Override
    protected String getNullableValue(String fullName, boolean forceNull) {
        return rw.getNullableString(fullName, forceNull);
    }

    @Override
    protected DataProvider getDataProvider(String prefix) {
        return new RequestDataProvider(rw, prefix);
    }
}
