package ru.yandex.calendar.util.data;

import org.jdom.Element;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.xml.jdom.JdomUtils;

/**
 * Provides data from a given xml element
 * @author ssytnik
 */
public class XmlDataProvider extends AbstractDataProvider<Element> {
    private Element element;

    public XmlDataProvider(Element element) {
        this.element = element;
    }

    @Override
    protected Element getItem(String name) {
        return element.getChild(name);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected ListF<Element> getItems(String name) {
        return Cf.<Element>x(element.getChildren(name));
    }

    @Override
    protected boolean isDefined(Element item, boolean isText) {
        return item != null && (isText ? StringUtils.isNotEmpty(getText(item)) : true);
    }

    @Override
    protected String getText(Element item) {
        return item.getText();
    }

    @Override
    protected DataProvider getDataProvider(Element item) {
        return new XmlDataProvider(item);
    }

    public static XmlDataProvider createFromString(String xml) {
        return new XmlDataProvider(JdomUtils.I.readRootElement(xml));
    }

    public static XmlDataProvider createFromFile(String filename) {
        //return new XmlDataProvider(XmlUtils.parseXml(AuxBase.readFileString(filename, null)));
        return new XmlDataProvider(JdomUtils.I.readRootElement(new File2(filename).readBytes()));
    }
}
