package ru.yandex.calendar.util.dates;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.event.repetition.RepetitionUtils;
import ru.yandex.calendar.logic.user.NameI18n;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class DateInterval {
    public final Option<DateOrDateTime> start;
    public final Option<DateOrDateTime> end;
    public final Option<NameI18n> title;

    public DateInterval(Option<DateOrDateTime> start, Option<DateOrDateTime> end) {
        this(start, end, Option.empty());
    }

    public DateInterval(Option<DateOrDateTime> start, Option<DateOrDateTime> end, Option<NameI18n> title) {
        Validate.isFalse(end.exists(e -> start.exists(e::isBefore)));
        this.start = start;
        this.end = end;
        this.title = title;
    }

    public InstantInterval toInstantInterval(DateTimeZone tz) {
        return new InstantInterval(
                start.map(date -> date.toInstant(tz)).getOrElse(RepetitionUtils.START_OF_EVERYTHING_TS),
                end.map(date -> date.toInstant(tz)).getOrElse(RepetitionUtils.END_OF_EVERYTHING_TS));
    }

    public boolean overlaps(LocalDate date) {
        DateOrDateTime st = DateOrDateTime.date(date);
        DateOrDateTime en = DateOrDateTime.date(date.plusDays(1));

        return !start.exists(s -> !en.isAfter(s)) && !end.exists(e -> !st.isBefore(e));
    }
}
