package ru.yandex.calendar.util.dates;

import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author Stepan Koltsov
 */
public class DateTimeManager {
    @Autowired
    private SettingsRoutines settingsRoutines;

    public static final DateTimeZone DEFAULT_TZ = MoscowTime.TZ;

    public DateTimeZone getTimeZoneForUid(final PassportUid uid) {
        return getTimeZonesForUids(Cf.list(uid)).single()._2;
    }

    public Function<PassportUid, DateTimeZone> getTimeZoneForUidF() {
        return new Function<PassportUid, DateTimeZone>() {
            public DateTimeZone apply(PassportUid uid) {
                return getTimeZoneForUid(uid);
            }
        };
    }

    public Tuple2List<PassportUid, DateTimeZone> getTimeZonesForUids(ListF<PassportUid> uids) {
        Tuple2List<PassportUid, Option<String>> found = settingsRoutines.getTimeZoneJavaIdsSafe(uids);
        MapF<PassportUid, DateTimeZone> x = Cf2.flatBy2(found).map2(AuxDateTime.getVerifyDateTimeZoneF()).toMap();

        return uids.zipWith(u -> x.getOrElse(u, getDefaultTimezone()));
    }

    public Chronology getChronologyForUid(PassportUid uid) {
        return ISOChronology.getInstance(getTimeZoneForUid(uid));
    }

    public DateTimeZone getDefaultTimezone() {
        return DEFAULT_TZ;
    }

} //~
