package ru.yandex.calendar.util.dates;

import java.util.Map;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationFieldType;

import ru.yandex.bolts.collection.Cf;

/**
 * Converts {@link DurationFieldType} to {@link DateTimeFieldType}
 * @author ssytnik
 */
public class DurationToDateTimeFieldTypeConv {
    private static final Map<DurationFieldType, DateTimeFieldType> durToDtFieldTypeMap;

    static {
        durToDtFieldTypeMap = Cf.hashMap();
        durToDtFieldTypeMap.put(DurationFieldType.years(), DateTimeFieldType.year());
        durToDtFieldTypeMap.put(DurationFieldType.months(), DateTimeFieldType.monthOfYear());
        // Don't support: durToDtFieldTypeMap.put(DurationFieldType.weeks(), DateTimeFieldType.weekOfWeekyear());
        durToDtFieldTypeMap.put(DurationFieldType.days(), DateTimeFieldType.dayOfMonth());
        durToDtFieldTypeMap.put(DurationFieldType.hours(), DateTimeFieldType.hourOfDay());
        durToDtFieldTypeMap.put(DurationFieldType.minutes(), DateTimeFieldType.minuteOfHour());
        durToDtFieldTypeMap.put(DurationFieldType.seconds(), DateTimeFieldType.secondOfMinute());
    }

    private DurationToDateTimeFieldTypeConv() {}

    public static DateTimeFieldType convert(DurationFieldType dft) { return durToDtFieldTypeMap.get(dft); }
}
