package ru.yandex.calendar.util.dates;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.Weeks;
import org.joda.time.chrono.ISOChronology;

/**
 * @author gutman
 */
public class ExtendedDateTime {

    private final Instant i;
    private final DateTimeZone tz;


    public ExtendedDateTime(Instant i, DateTimeZone tz) {
        this.i = i;
        this.tz = tz;
    }

    public ExtendedDateTime(DateTime dt) {
        this(dt.toInstant(), dt.getZone());
    }

    public Instant toInstantAtStartOfDay() {
        return i.toDateTime(tz).withTimeAtStartOfDay().toInstant();
    }

    public Instant toInstantAtEndOfDay() {
        return i.toDateTime(tz).plusDays(1).withTimeAtStartOfDay().toInstant();
    }

    public Instant toInstantAtStartOfWeek() {
        MutableDateTime m = i.toMutableDateTime(tz);
        m.setRounding(ISOChronology.getInstance(tz).weekOfWeekyear());
        return m.toInstant();
    }

    public Instant toInstantAtEndOfWeek() {
        MutableDateTime m = i.toMutableDateTime(tz);
        m.setRounding(ISOChronology.getInstance(tz).weekOfWeekyear());
        m.add(Weeks.ONE);
        return m.toInstant();
    }

}
