package ru.yandex.calendar.util.dates;

import org.joda.time.DateTime;
import org.joda.time.DateTimeConstants;
import org.joda.time.DateTimeFieldType;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.time.InstantInterval;

/**
 * @author dbrylev
 */
public enum TimeField {
    DAY(DateTimeFieldType.dayOfMonth()),
    WEEKDAYS(dt -> Option.when(
            dt.getDayOfWeek() != DateTimeConstants.SATURDAY && dt.getDayOfWeek() != DateTimeConstants.SUNDAY,
            new InstantInterval(
                    dt.withDayOfWeek(DateTimeConstants.MONDAY).withTime(0, 0, 0, 0),
                    dt.withDayOfWeek(DateTimeConstants.SATURDAY).withTime(0, 0, 0, 0)))),
    WEEK(DateTimeFieldType.weekOfWeekyear()),
    MONTH(DateTimeFieldType.monthOfYear()),
    ;

    private final Function<DateTime, Option<InstantInterval>> expander;

    TimeField(DateTimeFieldType field) {
        this(dt -> Option.of(new InstantInterval(
                dt.property(field).roundFloorCopy(), dt.property(field).roundCeilingCopy())));
    }

    TimeField(Function<DateTime, Option<InstantInterval>> expander) {
        this.expander = expander;
    }

    public Option<InstantInterval> expand(DateTime dt) {
        return expander.apply(dt);
    }
}
