package ru.yandex.calendar.util.dates;

import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.bolts.function.forhuman.Comparator;

/**
 * @author gutman
 */
public class TimeZones {

    public static Option<Duration> parseUtcOffset(String id) {
        Option<DateTimeZone> tzO = AuxDateTime.parseSimlpleOffsetTimeZone(id);
        return tzO.isPresent() ? Option.of(Duration.millis(tzO.get().getOffset(0))) : Option.empty();
    }

    private static final Tuple2List<DateTimeZone, String> descriptions = Tuple2List.fromPairs(
            DateTimeZone.forID("Pacific/Samoa"), "о. Мидуэй, Самоа",
            DateTimeZone.forID("Pacific/Honolulu"), "Гавайи",
            DateTimeZone.forID("America/Anchorage"), "Аляска",
            DateTimeZone.forID("America/Tijuana"), "Тихуана, Нижная Калифорния",
            DateTimeZone.forID("America/Los_Angeles"), "Тихоокеанское время (США и Канада)",
            DateTimeZone.forID("America/Phoenix"), "Аризона",
            DateTimeZone.forID("America/Denver"), "Горное время (США и Канада)",
            DateTimeZone.forID("America/Chihuahua"), "Ла Пас, Мазатлан, Чихуахуа",
            DateTimeZone.forID("America/Managua"), "Центральная Америка",
            DateTimeZone.forID("America/Regina"), "Саскачеван",
            DateTimeZone.forID("America/Mexico_City"), "Гвалахара, Мехико, Монтеррей",
            DateTimeZone.forID("America/Chicago"), "Центральное время (США и Канада)",
            DateTimeZone.forID("America/Indianapolis"), "Индиана (Восток)",
            DateTimeZone.forID("America/Bogota"), "Богота, Рио, Кито, Рио Бранко",
            DateTimeZone.forID("America/New_York"), "Восточное время (США и Канада)",
            DateTimeZone.forID("America/Caracas"), "Каракас, Ла Пас",
            DateTimeZone.forID("America/Halifax"), "Атлантическое время (Канада)",
            DateTimeZone.forID("Europe/Minsk"), "Минск",
            DateTimeZone.forID("America/Santiago"), "Сантьяго",
            DateTimeZone.forID("America/St_Johns"), "Ньюфаундленд",
            DateTimeZone.forID("America/Buenos_Aires"), "Буэнос Айрес, Джорджтаун",
            DateTimeZone.forID("America/Godthab"), "Гренландия",
            DateTimeZone.forID("America/Sao_Paulo"), "Бразилия",
            DateTimeZone.forID("America/Noronha"), "Среднеатлантическое время",
            DateTimeZone.forID("Atlantic/Cape_Verde"), "о-ва Зеленого мыса",
            DateTimeZone.forID("Atlantic/Azores"), "Азорские о-ва",
            DateTimeZone.forID("Africa/Casablanca"), "Касабланка, Монровия",
            DateTimeZone.forID("Europe/London"), "Дублин, Лондон, Лиссабон, Эдинбург",
            DateTimeZone.forID("Africa/Lagos"), "Западная Центральная Африка",
            DateTimeZone.forID("Europe/Berlin"), "Амстердам, Берлин, Берн, Вена, Рим, Стокгольм",
            DateTimeZone.forID("Europe/Paris"), "Брюссель, Копенгаген, Мадрид, Париж",
            DateTimeZone.forID("Europe/Sarajevo"), "Варшава, Загреб, Сараево, Скопье",
            DateTimeZone.forID("Europe/Belgrade"), "Белград, Братислава, Будапешт, Любляна, Прага",
            DateTimeZone.forID("Europe/Kiev"), "Киев",
            DateTimeZone.forID("Europe/Simferopol"), "Симферополь",
            DateTimeZone.forID("Africa/Johannesburg"), "Хараре, Претория",
            DateTimeZone.forID("Asia/Jerusalem"), "Иерусалим",
            DateTimeZone.forID("Europe/Istanbul"), "Афины, Бухарест, Стамбул",
            DateTimeZone.forID("Europe/Helsinki"), "Вильнюс, Рига, София, Таллинн, Хельсинки",
            DateTimeZone.forID("Africa/Cairo"), "Каир",
            DateTimeZone.forID("Europe/Bucharest"), "Бухарест",
            DateTimeZone.forID("Africa/Nairobi"), "Найроби",
            DateTimeZone.forID("Asia/Riyadh"), "Кувейт, Эр-Рияд",
            DateTimeZone.forID("Asia/Baghdad"), "Багдад",
            DateTimeZone.forID("Asia/Tehran"), "Тегеран",
            DateTimeZone.forID("Europe/Moscow"), "Москва, Санкт-Петербург, Волгоград",
            DateTimeZone.forID("Asia/Muscat"), "Абу-Даби, Мускат",
            DateTimeZone.forID("Asia/Tbilisi"), "Баку, Ереван, Тбилиси",
            DateTimeZone.forID("Europe/Samara"), "Самара",
            DateTimeZone.forID("Europe/Saratov"), "Саратов",
            DateTimeZone.forID("Asia/Kabul"), "Кабул",
            DateTimeZone.forID("Asia/Karachi"), "Исламабад, Карачи, Ташкент",
            DateTimeZone.forID("Asia/Calcutta"), "Бомбей, Калькутта, Мадрас, Нью-Дели",
            DateTimeZone.forID("Asia/Colombo"), "Шри Джаяварденепура",
            DateTimeZone.forID("Asia/Katmandu"), "Катманду",
            DateTimeZone.forID("Asia/Yekaterinburg"), "Екатеринбург",
            DateTimeZone.forID("Asia/Dhaka"), "Астана, Дхака",
            DateTimeZone.forID("Asia/Almaty"), "Алма-Ата",
            DateTimeZone.forID("Asia/Rangoon"), "Янгун (Рангун)",
            DateTimeZone.forID("Asia/Novosibirsk"), "Новосибирск",
            DateTimeZone.forID("Asia/Bangkok"), "Бангкок, Джакарта, Ханой",
            DateTimeZone.forID("Asia/Krasnoyarsk"), "Красноярск",
            DateTimeZone.forID("Australia/Perth"), "Перт",
            DateTimeZone.forID("Asia/Taipei"), "Тайпей",
            DateTimeZone.forID("Asia/Singapore"), "Куала-Лумпур, Сингапур",
            DateTimeZone.forID("Asia/Hong_Kong"), "Гонконг, Пекин, Урумчи",
            DateTimeZone.forID("Asia/Irkutsk"), "Иркутск, Улан-Батор",
            DateTimeZone.forID("Asia/Tokyo"), "Осака, Саппоро, Токио",
            DateTimeZone.forID("Asia/Seoul"), "Сеул",
            DateTimeZone.forID("Australia/Darwin"), "Дарвин",
            DateTimeZone.forID("Australia/Adelaide"), "Аделаида",
            DateTimeZone.forID("Asia/Yakutsk"), "Якутск",
            DateTimeZone.forID("Pacific/Guam"), "Гуам, Порт Моресби",
            DateTimeZone.forID("Australia/Brisbane"), "Брисбейн",
            DateTimeZone.forID("Asia/Vladivostok"), "Владивосток",
            DateTimeZone.forID("Asia/Sakhalin"), "Сахалин",
            DateTimeZone.forID("Australia/Hobart"), "Хобарт",
            DateTimeZone.forID("Australia/Sydney"), "Канберра, Мельбурн, Сидней",
            DateTimeZone.forID("Asia/Magadan"), "Магадан, Соломоновы о-ва",
            DateTimeZone.forID("Pacific/Fiji"), "Камчатка, Фиджи, Маршалловы о-ва",
            DateTimeZone.forID("Pacific/Auckland"), "Окленд, Веллингтон",
            DateTimeZone.forID("Pacific/Tongatapu"), "Нуку-алофа",

            DateTimeZone.forID("Asia/Barnaul"), "Барнаул",
            DateTimeZone.forID("Europe/Astrakhan"), "Астрахань",
            DateTimeZone.forID("Europe/Ulyanovsk"), "Ульяновск",
            DateTimeZone.forID("Europe/Kirov"), "Киров",
            DateTimeZone.forID("Asia/Tomsk"), "Томск"
    );

    public static Tuple2List<DateTimeZone, String> getDescriptionsSortedByOffset(Instant instant) {
        return descriptions
                .zip3With(Tuple2.<DateTimeZone, String>get1F().andThen(getOffsetF(instant)))
                .sortedBy3(Comparator.naturalComparator())
                .map23(printOffsetF());
    }

    private static Function<DateTimeZone, Integer> getOffsetF(final Instant instant) {
        return new Function<DateTimeZone, Integer>() {
            public Integer apply(DateTimeZone tz) {
                return tz.getOffset(instant);
            }
        };
    }

    private static Function2<String, Integer, String> printOffsetF() {
        return new Function2<String, Integer, String>() {
            public String apply(String description, Integer offsetMs) {
                LocalTime time = LocalTime.fromMillisOfDay(Math.abs(offsetMs));
                String offset =
                        offsetMs > 0 ? time.toString("+H:mm") :
                        offsetMs < 0 ? time.toString("-H:mm") : "";
                return "(UTC" + offset + ") " + description;
            }
        };
    }

}
