package ru.yandex.calendar.util.dates;

import org.joda.time.Duration;

import ru.yandex.misc.env.Environment;
import ru.yandex.misc.env.EnvironmentType;

/**
 * Timeouts used by servant
 * @author ssytnik
 */
public class Timeouts {
    // is there an easy way to check if developer notebook uses remote debug at the moment?
    private static final boolean WANT_USE_REMOTE_DEBUG_AT_DEV_ENV = false;
    private static final Duration LONG_DEBUG_TIMEOUT = Duration.standardHours(3L);

    private static final boolean useLongDebugTimeout = getUseLongDebugTimeout();
    private static final Duration commandTimeout = get(Duration.standardSeconds(9L));


    // https://jira.yandex-team.ru/browse/CAL-1813
    private static boolean getUseLongDebugTimeout() {
        if (WANT_USE_REMOTE_DEBUG_AT_DEV_ENV) {
            return EnvironmentType.getActive() == EnvironmentType.DEVELOPMENT;
        } else {
            return Environment.isDeveloperNotebook();
        }
    }

    private static Duration get(Duration desiredTimeout) {
        return useLongDebugTimeout && LONG_DEBUG_TIMEOUT.isLongerThan(desiredTimeout) ?
                LONG_DEBUG_TIMEOUT : desiredTimeout;
    }

    public static Duration getForCommand() { return commandTimeout; }
    public static Duration getForLongCommand() { return LONG_DEBUG_TIMEOUT; }
    public static Duration getForCommand(Duration desiredTimeout) { return get(desiredTimeout); }
}
