package ru.yandex.calendar.util.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;
import java.util.UUID;

import ru.yandex.calendar.logic.beans.NullableOtherValue;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.spring.jdbc.ArgPreparedStatementSetter;

/**
 * A simple configurator that supports inner configurators.
 *
 * @author ssytnik
 */
public class CalendarArgPreparedStatementSetter extends ArgPreparedStatementSetter {

    public CalendarArgPreparedStatementSetter(Object... paramValues) {
        super(paramValues);
    }

    @Override
    protected void setSimpleArg(PreparedStatement ps, int pos, Object arg) throws SQLException {
        if (arg instanceof Email) {
            setSimpleArg(ps, pos, ((Email) arg).normalize().getEmail());

        } else if (arg instanceof StringEnum) {
            ps.setObject(pos, ((StringEnum) arg).value(), Types.OTHER);

        } else if (arg instanceof NullableOtherValue) {
            NullableOtherValue<?> value = (NullableOtherValue<?>) arg;
            if (value.isNull()) {
                ps.setObject(pos, null, Types.OTHER);
            } else {
                setSimpleArg(ps, pos, value.get());
            }

        } else if (arg instanceof UUID) {
            ps.setObject(pos, ((UUID) arg).toString(), Types.OTHER);

        } else {
            super.setSimpleArg(ps, pos, arg);
        }
    }

} //~
