package ru.yandex.calendar.util.db;

import java.util.List;

import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.test.generic.CalendarDaoTestRunner;
import ru.yandex.calendar.test.generic.CalendarTestInitContextConfiguration;
import ru.yandex.calendar.test.generic.CalendarTestJdbcContextConfiguration;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.db.DataSourceUtils;
import ru.yandex.misc.db.embedded.ActivateEmbeddedPg;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.spring.jdbc.JdbcDaoSupport3;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.spring.jdbc.intercept.QueryInfo;

/**
 * @author Stepan Koltsov
 */
@RunWith(CalendarDaoTestRunner.class)
@TestExecutionListeners(value = TransactionForEachTestMethodCreator.class)
@ContextConfiguration(classes = {
        CalendarTestInitContextConfiguration.class,
        CalendarTestJdbcContextConfiguration.class,
})
@ActivateEmbeddedPg
public abstract class CalendarJdbcDaoSupport extends JdbcDaoSupport3 {

    @Autowired
    private JdbcTemplate3 jdbcTemplate;

    @Override
    protected void checkDaoConfig() {
        setJdbcTemplate(jdbcTemplate);
    }

    // not needed, disabled to work around https://jira.springsource.org/browse/SPR-8432
    /*
    @Override
    public CalendarJdbcTemplate getJdbcTemplate() {
        return (CalendarJdbcTemplate) super.getJdbcTemplate();
    }
    */

    // IDEA's test runner reports fail for CalendarJdbcDaoSupport's subclasses without any test method
    // therefore, we add this muted test doing nothing
    @Ignore
    @RunWithRandomTest
    public void testNothing() {}

    @Autowired
    private EnvironmentType environmentType;

    protected void logSkipped(String q, Object... args) {
        if (!DataSourceUtils.isNotQuietMode()) return;

        QueryInfo query = new QueryInfo(false, Option.of(q), Option.of(Cf.x(args)));

        LoggingQueryInterceptor.logger.info("Q: " + query.getQFormatted() + ": skipped");
    }

    protected boolean skipQuery(boolean condition, String q, Object... args) {
        if (condition && environmentType != EnvironmentType.TESTS) {
            logSkipped(q, args);

            return true;
        }
        return false;
    }

    protected boolean skipQuery(SqlCondition maybeFalse, String q, Object... args) {
        return skipQuery(maybeFalse.isConstantFalse(), q, args);
    }

    protected boolean skipQuery(ListF<?> maybeEmptyList1, ListF<?> maybeEmptyList2, String q, Object... args) {
        return skipQuery(maybeEmptyList1.isEmpty() || maybeEmptyList2.isEmpty(), q, args);
    }

    protected boolean skipQuery(List<?> maybeEmptyList, String q, Object... args) {
        return skipQuery(maybeEmptyList.isEmpty(), q, args);
    }

} //~
