package ru.yandex.calendar.util.db;

import javax.sql.DataSource;

import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.calendar.logic.beans.Bean;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;
import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptor;
import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptors;

/**
 * @author Stepan Koltsov
 */
public class CalendarJdbcTemplate extends JdbcTemplate3 {

    private final QueryInterceptor queryInterceptor;

    public CalendarJdbcTemplate(DataSource dataSource) {
        super(dataSource);
        queryInterceptor = QueryInterceptors.defaultQueryInterceptor();
    }

    public CalendarJdbcTemplate(DataSource dataSource, QueryInterceptor queryInterceptor) {
        super(dataSource);
        this.queryInterceptor = queryInterceptor;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        if (Bean.class.isAssignableFrom(requiredType)) {
            return (RowMapper<T>) BeanHelper.forBean(ClassX.wrap(requiredType).<Bean>uncheckedCast()).beanRowMapper();
        } else {
            return super.getSingleColumnRowMapper(requiredType);
        }
    }

    @Override
    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) {
        return new CalendarArgPreparedStatementSetter(args);
    }

    @Override
    protected QueryInterceptor createQueryInterceptor() {
        return queryInterceptor;
    }
} //~
