package ru.yandex.calendar.util.db;

import javax.sql.DataSource;

import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptor;
import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptors;

public class CalendarQueryInterceptors {

    public static QueryInterceptor create(
            DataSource dataSource,
            ReadFromSlaveQueryInterceptor readSlaveInterceptor
    ) {
        return QueryInterceptors.combine(
                new QueryInterceptors.AssertNoNetworkAccessQueryInterceptor(),
                new QueryInterceptors.WtdQueryInterceptor(),
                new QueryInterceptors.TltQueryInterceptor(),
                readSlaveInterceptor,
                ((DcAwareDynamicMasterSlaveDataSource) dataSource).getLoggingInterceptor()
        );
    }
}
