package ru.yandex.calendar.util.db;

import java.sql.CallableStatement;
import java.sql.Connection;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.experimental.Delegate;

class CallableStatementWithMetrics extends PreparedStatementWithMetrics implements CallableStatement {
    @Delegate(excludes = StatementExecuteMethodsInterface.class)
    private final CallableStatement target;

    CallableStatementWithMetrics(Connection owner, CallableStatement target, String query, MeterRegistry registry) {
        super(owner, target, query, registry);
        this.target = target;
    }
}
