package ru.yandex.calendar.util.db;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.db.q.ConditionUtils;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlQueryUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
public class ColumnsInSetCondition extends SqlCondition {

    private final ListF<ConditionUtils.Column> columns;
    private final ListF<?> values;

    public ColumnsInSetCondition(ListF<ConditionUtils.Column> columns, ListF<?> values) {
        Validate.isTrue(columns.size() > 1);
        Validate.notEmpty(values);

        this.columns = columns;
        this.values = values;
    }

    @Override
    public ListF<Object> args() {
        return values.uncheckedCast();
    }

    @Override
    public String sql(Option<String> tableName) {
        String qms = "(" + SqlQueryUtils.qms(columns.size()) + ")";

        return columns.map(c -> c.sql(tableName)).mkString("(", ", ",")")
                + " IN " + Cf.repeat(qms, values.size()).mkString("(", ", ", ")");
    }
}
