package ru.yandex.calendar.util.db;

import java.sql.Connection;
import java.sql.SQLException;

import io.micrometer.core.instrument.MeterRegistry;
import org.apache.commons.dbcp2.ConnectionFactory;

public class ConnectionFactoryWithMetrics implements ConnectionFactory {
    private final ConnectionFactory target;
    private final String url;
    private final MeterRegistry registry;

    public ConnectionFactoryWithMetrics(ConnectionFactory target, String url, MeterRegistry registry) {
        this.target = target;
        this.url = url;
        this.registry = registry;
    }

    @Override
    public Connection createConnection() throws SQLException {
        return new ConnectionWithMetrics(target.createConnection(), registry);
    }
}
