package ru.yandex.calendar.util.db;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public interface ConnectionMethodsNotDelegated {
    StatementWithMetrics createStatement() throws SQLException;

    PreparedStatement prepareStatement(String sql) throws SQLException;

    CallableStatement prepareCall(String sql) throws SQLException;

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency,
            int resultSetHoldability) throws SQLException;

    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)
            throws
            SQLException;

    PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException;

    PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException;

    PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException;

    Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability);

    Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException;

    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException;

    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException;
}
