package ru.yandex.calendar.util.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

import io.micrometer.core.instrument.MeterRegistry;
import lombok.SneakyThrows;
import lombok.experimental.Delegate;

public class ConnectionWithMetrics implements Connection {
    @Delegate(excludes = ConnectionMethodsNotDelegated.class)
    protected final Connection target;
    private final MeterRegistry registry;

    ConnectionWithMetrics(Connection target, MeterRegistry registry) {
        this.target = target;
        this.registry = registry;
    }

    @Override
    @SneakyThrows
    public StatementWithMetrics createStatement() {
        return new StatementWithMetrics(this, target.createStatement(), registry);
    }

    @Override
    @SneakyThrows
    public PreparedStatement prepareStatement(String sql) {
        return new PreparedStatementWithMetrics(this, target.prepareStatement(sql), sql, registry);
    }

    @Override
    @SneakyThrows
    public CallableStatement prepareCall(String sql) {
        return new CallableStatementWithMetrics(this, target.prepareCall(sql), sql, registry);
    }

    @Override
    @SneakyThrows
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PreparedStatementWithMetrics(this, target.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, registry);
    }

    @Override
    @SneakyThrows
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new CallableStatementWithMetrics(this, target.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, registry);
    }

    @Override
    @SneakyThrows
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new PreparedStatementWithMetrics(this, target.prepareStatement(sql, autoGeneratedKeys), sql, registry);
    }

    @Override
    @SneakyThrows
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new PreparedStatementWithMetrics(this, target.prepareStatement(sql, columnIndexes), sql, registry);
    }

    @Override
    @SneakyThrows
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new PreparedStatementWithMetrics(this, target.prepareStatement(sql, columnNames), sql, registry);
    }

    @Override
    @SneakyThrows
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new StatementWithMetrics(this, target.createStatement(resultSetType, resultSetConcurrency), registry);
    }

    @Override
    @SneakyThrows
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return new PreparedStatementWithMetrics(this, target.prepareStatement(sql, resultSetType, resultSetConcurrency), sql, registry);
    }

    @Override
    @SneakyThrows
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return new CallableStatementWithMetrics(this, target.prepareCall(sql, resultSetType, resultSetConcurrency), sql, registry);
    }

    @Override
    @SneakyThrows
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new StatementWithMetrics(this, target.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), registry);
    }
}
